-- reload updates table

use pcmag
go

-- drop table
drop table updates
go

-- create table
create table updates (
p_key	int	not null,
p_int	int	not null,
p_signed	int null,
p_float	float(4)	not null,
p_double	float(8)	not null,
p_decim	numeric (18,4)	not null,
p_date	datetime	not null,
p_code	char(10)	not null,
p_name	char(20)	not null,
p_address	varchar(80)	not null
)
go

-- load table
sp_dboption 'pcmag', 'select into/bulkcopy', true
go
checkpoint
go
bulk insert updates from 'd:\data\updates.dat' with (DATAFILETYPE = 'char', FIELDTERMINATOR = ',', TABLOCK)
go
checkpoint
go
sp_dboption 'pcmag', 'select into/bulkcopy', false
go
checkpoint
go

-- add indices
alter table updates add constraint updates_key_PK_IDX primary key clustered (p_key)
go
create index updates_int_IDX on updates (p_int)
go
alter table updates add constraint updates_int_FK foreign key (p_int) references hundred (h_key)
go
create index updates_signed_IDX on updates (p_signed)
go
create index updates_decim_IDX on updates (p_decim)
go
create index updates_date_IDX on updates (p_date)
go
alter table updates add constraint updates_code_CK_IDX unique (p_code)
go

-- done

checkpoint
go
